// Popup script for settings

document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('settings-form');
  const emailInput = document.getElementById('user-email');
  const saveBtn = document.getElementById('save-btn');
  const statusDiv = document.getElementById('status');

  // Load saved settings
  chrome.storage.sync.get(['userEmail'], (result) => {
    if (result.userEmail) {
      emailInput.value = result.userEmail;
    }
  });

  // Handle form submission
  form.addEventListener('submit', async (e) => {
    e.preventDefault();

    const email = emailInput.value.trim().toLowerCase();

    if (!email) {
      showStatus('Please enter your email address', 'error');
      return;
    }

    if (!email.includes('@')) {
      showStatus('Please enter a valid email address', 'error');
      return;
    }

    // Show loading state
    saveBtn.disabled = true;
    saveBtn.textContent = 'Saving...';

    try {
      // Save settings
      await chrome.storage.sync.set({
        userEmail: email
      });

      showStatus('✓ Settings saved! You can now use the AI assistant on Freshdesk.', 'success');

      // Reset button after delay
      setTimeout(() => {
        saveBtn.disabled = false;
        saveBtn.textContent = 'Save Settings';
      }, 2000);

    } catch (error) {
      console.error('Error saving settings:', error);
      showStatus('Error: ' + error.message, 'error');

      saveBtn.disabled = false;
      saveBtn.textContent = 'Save Settings';
    }
  });

  function showStatus(message, type) {
    statusDiv.textContent = message;
    statusDiv.className = `status ${type} show`;

    if (type === 'success') {
      setTimeout(() => {
        statusDiv.classList.remove('show');
      }, 5000);
    }
  }
});
