// Background service worker for the extension

console.log('Replymate background service worker loaded');

// Listen for installation
chrome.runtime.onInstalled.addListener((details) => {
  if (details.reason === 'install') {
    console.log('Extension installed - Click the extension icon to configure your API key');
  } else if (details.reason === 'update') {
    console.log('Extension updated');
  }
});

// Listen for messages from content script (if needed for future features)
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('Message received:', request);

  if (request.action === 'getConfig') {
    chrome.storage.sync.get(['openaiApiKey', 'openaiModel'], (result) => {
      sendResponse({
        apiKey: result.openaiApiKey || null,
        model: result.openaiModel || 'gpt-4o-mini'
      });
    });
    return true; // Keep channel open for async response
  }

  if (request.action === 'logUsage') {
    // Future: Track usage statistics
    console.log('Usage logged:', request.data);
  }

  return false;
});

// Handle extension icon click (opens popup automatically)
chrome.action.onClicked.addListener((tab) => {
  console.log('Extension icon clicked');
});
