# Testing Checklist

Use this checklist to verify the extension works correctly.

## Pre-Installation Tests

- [ ] Chrome version is 88 or higher (`chrome://version`)
- [ ] Have OpenAI API key ready
- [ ] Have access to Freshdesk portal

## Installation Tests

- [ ] Can navigate to `chrome://extensions`
- [ ] Developer mode can be enabled
- [ ] Extension loads without errors
- [ ] Extension icon appears in toolbar
- [ ] No red errors shown in extensions page

## Configuration Tests

- [ ] Click extension icon opens popup
- [ ] Popup displays correctly
- [ ] Can enter API key
- [ ] Can select model
- [ ] Save button works
- [ ] Success message appears
- [ ] Invalid API key shows error
- [ ] Settings persist after closing popup

## Freshdesk Integration Tests

### Button Injection

- [ ] Navigate to Freshdesk ticket page
- [ ] "🤖 AI Suggest" button appears in toolbar
- [ ] Button has correct styling (green, readable)
- [ ] Button shows tooltip on hover
- [ ] Button appears on multiple different tickets

### Context Extraction

Test on different ticket types:

- [ ] Ticket with simple customer email
- [ ] Ticket with quoted reply chain
- [ ] Ticket with HTML formatted content
- [ ] Ticket with attachments
- [ ] New ticket vs old ticket

Verify extraction of:
- [ ] Customer name extracted correctly
- [ ] Subject line extracted
- [ ] Customer message extracted (primary content, not quotes)
- [ ] Ticket ID extracted from URL

### AI Generation

- [ ] Click "AI Suggest" button
- [ ] Loading modal appears
- [ ] Loading animation works
- [ ] API call completes in <5 seconds
- [ ] Result modal appears with reply
- [ ] Reply is relevant to customer message
- [ ] Reply is professional and friendly
- [ ] Reply mentions Robomate context appropriately

### Result Actions

- [ ] "Copy to Clipboard" button works
- [ ] Copied text matches displayed reply
- [ ] "Insert into Reply" button works
- [ ] Text is inserted into Freshdesk editor
- [ ] Formatting preserved (line breaks)
- [ ] Editor receives focus after insertion
- [ ] Close button (×) works
- [ ] Click outside modal closes it

## Error Handling Tests

- [ ] Test with no API key configured → shows warning message
- [ ] Test with invalid API key → shows error
- [ ] Test on non-ticket page → button doesn't appear
- [ ] Test before clicking "Reply" → shows helpful message
- [ ] Test with empty ticket → shows "no message" error
- [ ] Test with API down → shows error gracefully
- [ ] Test with very long customer message → works

## Edge Cases

- [ ] Multiple browser tabs open → works in all
- [ ] Navigate between tickets → button re-appears
- [ ] Freshdesk SPA navigation → button persists
- [ ] Reload page → button re-injects
- [ ] Very long reply generated → scrollable in modal
- [ ] Special characters in message → handled correctly
- [ ] Multiple languages → works (passes through to API)

## Performance Tests

- [ ] Extension doesn't slow down Freshdesk loading
- [ ] Button injection happens within 1 second
- [ ] No memory leaks after multiple uses
- [ ] No console errors during normal operation
- [ ] API calls don't block UI

## Security Tests

- [ ] API key not visible in network inspector
- [ ] API key not logged to console
- [ ] Extension only active on Freshdesk domains
- [ ] No requests to unexpected domains
- [ ] Storage uses Chrome sync (encrypted)

## Cross-Browser Tests (Chromium)

- [ ] Works in Chrome
- [ ] Works in Edge
- [ ] Works in Brave
- [ ] Works in other Chromium browsers

## Update Tests

- [ ] Make minor code change
- [ ] Reload extension from `chrome://extensions`
- [ ] Changes take effect
- [ ] Settings preserved after reload
- [ ] No errors after reload

## User Experience Tests

- [ ] UI is intuitive (no manual needed)
- [ ] Loading states are clear
- [ ] Error messages are helpful
- [ ] Button placement makes sense
- [ ] Colors match Freshdesk theme reasonably
- [ ] Modal is easy to read
- [ ] Actions are obvious

## Regression Tests

After any code changes, verify:

- [ ] Installation still works
- [ ] Configuration still works
- [ ] Button still injects
- [ ] AI generation still works
- [ ] Insertion still works
- [ ] No new console errors

## Acceptance Criteria

Before deploying to team:

✅ All installation tests pass
✅ All configuration tests pass
✅ Core functionality (generate + insert) works
✅ No critical bugs
✅ Error messages are helpful
✅ Performance is acceptable
✅ Works on real production tickets

## Test Results

| Test Category | Status | Notes | Date |
|---------------|--------|-------|------|
| Installation | | | |
| Configuration | | | |
| Button Injection | | | |
| Context Extraction | | | |
| AI Generation | | | |
| Result Actions | | | |
| Error Handling | | | |
| Edge Cases | | | |
| Performance | | | |
| Security | | | |

## Known Issues

List any known issues here:

1.
2.
3.

## Test on These Tickets

Use these test cases:

1. **Simple inquiry**: "When will my order ship?"
2. **Problem report**: "My Luba wheel is damaged"
3. **Complaint**: "I'm unhappy with service"
4. **Complex issue**: Multi-paragraph technical problem
5. **Follow-up**: Reply to existing conversation

## Sign-off

Tested by: _______________
Date: _______________
Version: _______________

✅ Ready for team deployment
⚠️ Issues to fix (see above)
❌ Not ready
