# Robomate Freshdesk AI Assistant - Chrome Extension

A Chrome extension that adds AI-powered reply suggestions directly into your Freshdesk interface.

## Features

✅ **Seamless Integration** - Adds "🤖 AI Suggest" button right in Freshdesk toolbar
✅ **Smart Context Extraction** - Automatically reads customer name, message, and ticket details
✅ **Direct OpenAI Integration** - Calls OpenAI API directly (bypasses CSP restrictions)
✅ **One-Click Insertion** - Insert AI-generated reply into editor with one click
✅ **Secure** - API key stored in Chrome's secure sync storage
✅ **Fast** - Generates replies in ~2-3 seconds
✅ **Cost Effective** - ~$0.001 per reply with GPT-4o Mini

## Installation (30 seconds)

### Step 1: Get OpenAI API Key

1. Go to https://platform.openai.com/api-keys
2. Create a new API key
3. Copy it (starts with `sk-...`)

### Step 2: Install Extension

1. Open Chrome and go to `chrome://extensions`
2. Toggle **"Developer mode"** ON (top right corner)
3. Click **"Load unpacked"**
4. Select the `chrome-extension` folder
5. Extension installed! ✓

### Step 3: Configure API Key

1. Click the extension icon in Chrome toolbar (🤖 icon)
2. Paste your OpenAI API key
3. Select model (GPT-4o Mini recommended)
4. Click "Save Settings"
5. Done! ✓

## Usage

### On Any Freshdesk Ticket:

1. Open any ticket on your Freshdesk portal
2. Click "Reply" to open the reply editor
3. Click the **"🤖 AI Suggest"** button (in the toolbar)
4. Wait 2-3 seconds for AI to generate reply
5. Review the suggested reply
6. Click **"Insert into Reply"** or **"Copy to Clipboard"**
7. Edit if needed and send!

## How It Works

```
User clicks "AI Suggest"
         ↓
Extension extracts:
  - Customer name
  - Subject line
  - Customer message
  - Ticket context
         ↓
Sends to OpenAI API
         ↓
Generates professional reply
         ↓
Shows popup with suggestion
         ↓
User inserts or copies
```

## File Structure

```
chrome-extension/
├── manifest.json          # Extension configuration
├── content.js             # Main logic (runs on Freshdesk pages)
├── content.css            # UI styling
├── vim-navigation.js      # Vim keyboard navigation
├── vim-navigation.css     # Vim navigation styles
├── popup.html             # Settings popup UI
├── popup.js               # Settings logic
├── background.js          # Background service worker
├── icons/
│   ├── icon16.png        # 16x16 icon
│   ├── icon48.png        # 48x48 icon
│   ├── icon128.png       # 128x128 icon
│   └── robomate-logo.png # Logo for AI button
├── README.md             # This file
├── DESIGN.md             # Architecture & security design doc
├── INSTALL.md            # Installation guide
└── TESTING.md            # Testing guide
```

## Supported Browsers

✅ **Chrome** (Recommended)
✅ **Edge** (Chromium-based)
✅ **Brave**
✅ **Any Chromium-based browser**

❌ Firefox (requires different manifest, can be ported)
❌ Safari (requires different format)

## Updating the Extension

1. Make changes to extension files
2. Go to `chrome://extensions`
3. Click refresh icon on the extension card
4. Changes applied! ✓

## Sharing with Team

### Method 1: Folder Sharing (Easiest)
1. Share the `chrome-extension` folder (Google Drive, network share, etc.)
2. Each team member follows installation steps above
3. Takes 30 seconds per person

### Method 2: ZIP Distribution
1. Zip the `chrome-extension` folder
2. Email or share the ZIP
3. Team members extract and install

### Method 3: Chrome Web Store (Optional)
- Submit to Chrome Web Store for one-click installation
- Costs $5 one-time developer fee
- Takes 2-3 days for approval
- Makes installation easier but not necessary

## Security

- **API Key Storage**: Stored in Chrome's secure sync storage
- **Encrypted sync**: Syncs across user's Chrome devices (encrypted)
- **No data collection**: Extension doesn't collect or send any data except to OpenAI
- **Secure API calls**: Direct HTTPS calls to OpenAI only
- **No external servers**: All logic runs locally in browser

## Troubleshooting

### Extension not appearing in toolbar
- Check `chrome://extensions` - make sure it's enabled
- Click the puzzle icon in Chrome toolbar → pin the extension

### "Configure API key" message
- Click extension icon
- Enter your OpenAI API key
- Make sure it starts with `sk-`

### "Could not extract customer message"
- Make sure you're on a ticket detail page (URL: .../tickets/NUMBER)
- Ticket must have at least one customer message
- Scroll so message is visible

### "API request failed"
- Check your API key is correct
- Check you have credits: https://platform.openai.com/usage
- Try regenerating your API key

### Button not appearing
- Refresh the Freshdesk page
- Check browser console (F12) for errors
- Make sure extension is enabled

### To reset everything
1. Go to `chrome://extensions`
2. Click "Remove" on the extension
3. Re-install following steps above

## Cost Estimate

Using **GPT-4o Mini** (recommended):
- Input: ~300 tokens per request
- Output: ~200 tokens per request
- Cost: ~$0.001 per reply (1/10 of a cent)

**Monthly estimate:**
- 100 replies/day = ~$3/month
- 500 replies/day = ~$15/month

Using **GPT-4o**:
- ~10x more expensive
- Better quality for complex cases
- ~$0.01 per reply

## Future Enhancements (Roadmap)

### Phase 1 (Current)
✅ Basic AI reply generation
✅ Direct OpenAI integration
✅ Manual trigger via button

### Phase 2 (Easy Additions)
- [ ] Tone selector (formal, friendly, apologetic)
- [ ] Response templates for common issues
- [ ] Reply history/cache
- [ ] Keyboard shortcut (e.g., Alt+A)

### Phase 3 (Backend Integration) - See [DESIGN.md](./DESIGN.md) for details
- [ ] Cloudflare Worker API with AI Gateway
- [ ] JWT-based authentication system
- [ ] Multi-layer security (rate limiting, domain allowlist, fingerprinting)
- [ ] Real-time cost monitoring dashboard
- [ ] Per-user/team usage analytics
- [ ] Team-wide prompt customization
- [ ] Knowledge base integration
- [ ] Auto-categorize tickets

### Phase 4 (Advanced)
- [ ] Auto-draft replies (no click needed)
- [ ] Multi-language support
- [ ] Sentiment analysis
- [ ] Quality scoring
- [ ] Learning from agent edits

## Development

### Testing locally
1. Make changes to files
2. Go to `chrome://extensions`
3. Click refresh icon
4. Test on Freshdesk

### Debugging
1. Open Freshdesk ticket page
2. Press F12 → Console tab
3. Look for logs starting with "🤖"
4. Check for errors

### Adding features
- Edit `content.js` for main logic
- Edit `content.css` for styling
- Edit `popup.html`/`popup.js` for settings
- Update `manifest.json` if adding permissions

## License

Internal use for Robomate only.

## Support

For issues or questions:
1. Check browser console (F12) for errors
2. Verify API key is correct
3. Check OpenAI account has credits
4. Contact your development team

## Version History

### v1.0.0 (Current)
- Initial release
- Basic AI reply generation
- Direct OpenAI integration
- Settings UI for API key configuration
- Context extraction from Freshdesk tickets
- One-click insertion into reply editor

---

Built with ❤️ for Robomate Team
