# Replymate Chrome Extension - Installation Guide

## Quick Install (2 minutes)

### Step 1: Install the Extension

1. Open Google Chrome
2. Go to `chrome://extensions/`
3. Enable "Developer mode" (toggle in top-right corner)
4. Click "Load unpacked"
5. Navigate to and select this folder: `chrome-extension/`
6. The extension should now appear in your extensions list

### Step 2: Configure Your Email

1. Click the Replymate extension icon in Chrome toolbar (puzzle piece icon → Replymate)
2. Enter your work email: `your.name@robomate.co.nz`
3. Click "Save Settings"
4. You should see "✓ Settings saved!"

**Important:** Use your @robomate.co.nz email address (or lockmeister@gmail.com if applicable)

### Step 3: Test It Out

1. Go to any Freshdesk ticket: https://your-freshdesk.com/tickets/[number]
2. Look for the yellow "✨ AI Suggest" button near the reply box
3. Click it to generate an AI-powered reply
4. Edit the suggestion as needed
5. Click "Insert into Reply" to use it

**That's it! You're ready to go.**

## What You'll See

### In Freshdesk Tickets

- **"✨ AI Suggest" button** appears near the reply editor
- Click it to generate a professional response

### In the Suggestion Modal

The AI analyzes the customer's message and generates a reply you can:

- ✅ **Edit individual sentences** - Click any sentence to edit it
- ✅ **Delete sentences** - Click the X next to any sentence and select why you deleted it
- ✅ **Fill dropdowns** - Replace [AVAILABILITY], [DELIVERY TIME], etc. with actual info
- ✅ **Add feedback** - Optional comment box for overall feedback
- ✅ **Insert into reply** - Copies the final text to Freshdesk reply box

All your edits and feedback are automatically sent to our backend for analytics and improvement!

## Authorized Users (34 total)

The extension only works for these email addresses:

- lockmeister@gmail.com
- All @robomate.co.nz team members (33 people)

If you try to use an unauthorized email, the extension will show an error.

## Troubleshooting

### "Please configure your email" error

- Click the extension icon and enter your @robomate.co.nz email
- Make sure to click "Save Settings"

### "Unauthorized" error

- Check that you used your @robomate.co.nz email (not @gmail.com or other)
- Make sure you're on the whitelist (see above)

### Button doesn't appear

- Refresh the Freshdesk page
- Make sure you're on a ticket page (not the ticket list)
- Check that the extension is enabled in chrome://extensions/

### AI generation fails

- Check your internet connection
- Try refreshing the page and clicking again
- Check browser console for error messages (F12 → Console tab)

## Privacy & Data

### What We Track

✅ **Generations:**
- Ticket ID, URL, and Freshdesk domain
- Customer name and message
- AI-generated reply
- Your email (to know who generated it)
- Timestamp

✅ **Feedback:**
- Which sentences you edited or deleted
- Why you deleted them (optional reasons: too-formal, too-casual, etc.)
- Your optional comments
- Final reply text

❌ **What We DON'T Track:**
- Your API keys (we use a shared backend key)
- Your password or Freshdesk credentials
- Any data from other websites
- Browsing history

### Data Security

- All data stored in Cloudflare's secure D1 database
- No API keys stored in your browser
- Email-based authentication with whitelist
- CORS protection (only works from Freshdesk)

## Need Help?

Contact the extension developer or check:
- Browser console (F12 → Console) for error messages
- Extension popup for configuration issues
- Cloudflare Worker logs for backend issues

## Version

**Replymate v1.0.0**
Backend: https://robomate-backend.thelockmeister.workers.dev
By Robomate - https://robomate.co.nz
