# Quick Installation Guide

## 🚀 Install in 3 Minutes

### Before You Start

You need:
- ✅ Google Chrome (or Edge, Brave)
- ✅ OpenAI API key ([get one here](https://platform.openai.com/api-keys))

---

## Step 1: Install Extension (1 minute)

### Chrome

1. Open Chrome
2. Type `chrome://extensions` in address bar
3. Press Enter
4. Toggle **"Developer mode"** ON (top-right corner)

   ![Developer Mode](https://i.imgur.com/X1YZ.png)

5. Click **"Load unpacked"** button
6. Navigate to and select the `chrome-extension` folder
7. Extension appears! ✓

### Edge

1. Open Edge
2. Type `edge://extensions` in address bar
3. Toggle **"Developer mode"** ON
4. Click **"Load unpacked"**
5. Select the `chrome-extension` folder
6. Done! ✓

---

## Step 2: Configure API Key (1 minute)

1. **Find the extension icon** in Chrome toolbar
   - Look for 🤖 icon (green circle)
   - If not visible: Click puzzle icon → pin the extension

2. **Click the extension icon** 🤖

3. **Enter your API key**:
   - Paste your OpenAI API key (starts with `sk-...`)
   - Select model: **GPT-4o Mini** (recommended)
   - Click **"Save Settings"**

4. Wait for "Settings saved successfully" message ✓

---

## Step 3: Test It! (1 minute)

1. Go to your Freshdesk portal:
   - https://robomateco-help.freshdesk.com

2. Open any ticket

3. Click **"Reply"** button to open reply editor

4. Look for **"🤖 AI Suggest"** button in toolbar

5. Click it!

6. Wait 2-3 seconds

7. See AI-generated reply! ✓

8. Click **"Insert into Reply"**

9. Done! Edit if needed and send

---

## ✅ You're Ready!

The extension is now installed and configured.

Use it on any Freshdesk ticket by clicking the **"🤖 AI Suggest"** button.

---

## 🆘 Troubleshooting

### Can't see extension icon in toolbar?
→ Click puzzle icon in Chrome toolbar → pin the extension

### "Configure API key" error?
→ Click extension icon → enter your OpenAI API key

### Button not appearing on Freshdesk?
→ Refresh the page, make sure you're on a ticket detail page

### Need help?
→ Check the full [README.md](README.md) for detailed docs

---

## 📤 Sharing with Team

To share with your team:

1. **Share this folder**:
   - Upload to Google Drive, Dropbox, or network share
   - Or ZIP it and email

2. **Each team member**:
   - Downloads the folder
   - Follows Steps 1-2 above (3 minutes)
   - Gets their own OpenAI API key (or use shared key)

**No approval needed!** Works immediately.

---

## 💡 Pro Tips

- **Keyboard shortcut**: Click button or use keyboard (coming soon)
- **Multiple models**: Change in settings if replies need more detail
- **Copy instead of insert**: Use "Copy" button to paste manually
- **Edit replies**: Always review and personalize before sending

---

## 📊 Cost Tracking

- Each reply costs ~$0.001 (GPT-4o Mini)
- Track usage at: https://platform.openai.com/usage
- Set spending limits in OpenAI dashboard

---

## 🔄 Updating

When you get an updated version:

1. Go to `chrome://extensions`
2. Find "Robomate Freshdesk AI Assistant"
3. Click refresh icon 🔄
4. Done!

---

**That's it! You're all set.** 🎉

Start generating AI replies on your Freshdesk tickets now!
